; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=hexagon < %s | FileCheck %s
; RUN: llc -mtriple=hexagon-unknown-linux-gnu < %s | FileCheck %s
; RUN: llc -mtriple=hexagon-unknown-linux-musl < %s | FileCheck %s

define { half, i32 } @test_frexp_f16_i32(half %a) nounwind {
; CHECK-LABEL: test_frexp_f16_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     call __extendhfsf2
; CHECK-NEXT:     allocframe(r29,#8):raw
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call __truncsfhf2
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = memw(r29+#4)
; CHECK-NEXT:     dealloc_return
; CHECK-NEXT:    }
  %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
  ret { half, i32 } %result
}

define half @test_frexp_f16_i32_only_use_fract(half %a) nounwind {
; CHECK-LABEL: test_frexp_f16_i32_only_use_fract:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     call __extendhfsf2
; CHECK-NEXT:     allocframe(r29,#8):raw
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call __truncsfhf2
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r31:30 = dealloc_return(r30):raw
; CHECK-NEXT:    }
  %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
  %result.0 = extractvalue { half, i32 } %result, 0
  ret half %result.0
}

define i32 @test_frexp_f16_i32_only_use_exp(half %a) nounwind {
; CHECK-LABEL: test_frexp_f16_i32_only_use_exp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     call __extendhfsf2
; CHECK-NEXT:     allocframe(r29,#8):raw
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = memw(r29+#4)
; CHECK-NEXT:     dealloc_return
; CHECK-NEXT:    }
  %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
  %result.0 = extractvalue { half, i32 } %result, 1
  ret i32 %result.0
}

define { <2 x half>, <2 x i32> } @test_frexp_v2f16_v2i32(<2 x half> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f16_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r17:16 = combine(r2,r0)
; CHECK-NEXT:     r0 = r3
; CHECK-NEXT:     memd(r29+#-16) = r17:16
; CHECK-NEXT:     allocframe(#32)
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call __extendhfsf2
; CHECK-NEXT:     memd(r29+#16) = r19:18
; CHECK-NEXT:     memd(r29+#8) = r21:20
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call __extendhfsf2
; CHECK-NEXT:     r18 = r0
; CHECK-NEXT:     r0 = r17
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call __truncsfhf2
; CHECK-NEXT:     r20 = memw(r29+#4)
; CHECK-NEXT:     r21 = memw(r29+#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call __truncsfhf2
; CHECK-NEXT:     r17 = r0
; CHECK-NEXT:     r0 = r18
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     memh(r16+#2) = r0
; CHECK-NEXT:     memh(r16+#0) = r17
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     memd(r16+#8) = r21:20
; CHECK-NEXT:     r17:16 = memd(r29+#24)
; CHECK-EMPTY:
; CHECK-NEXT:    } :mem_noshuf // 8-byte Folded Reload
; CHECK-NEXT:    {
; CHECK-NEXT:     r19:18 = memd(r29+#16)
; CHECK-NEXT:     r21:20 = memd(r29+#8)
; CHECK-NEXT:    } // 8-byte Folded Reload
; CHECK-NEXT:    {
; CHECK-NEXT:     r31:30 = dealloc_return(r30):raw
; CHECK-NEXT:    }
  %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
  ret { <2 x half>, <2 x i32> } %result
}

define <2 x half> @test_frexp_v2f16_v2i32_only_use_fract(<2 x half> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f16_v2i32_only_use_fract:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     call __extendhfsf2
; CHECK-NEXT:     r16 = r1
; CHECK-NEXT:     memd(r29+#-16) = r17:16
; CHECK-NEXT:     allocframe(#16)
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call __truncsfhf2
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call __extendhfsf2
; CHECK-NEXT:     r17 = r0
; CHECK-NEXT:     r0 = r16
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call __truncsfhf2
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = zxth(r0)
; CHECK-NEXT:     r2 = zxth(r17)
; CHECK-NEXT:     r17:16 = memd(r29+#8)
; CHECK-NEXT:    } // 8-byte Folded Reload
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = r2
; CHECK-NEXT:     dealloc_return
; CHECK-NEXT:    }
  %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
  %result.0 = extractvalue { <2 x half>, <2 x i32> } %result, 0
  ret <2 x half> %result.0
}

define <2 x i32> @test_frexp_v2f16_v2i32_only_use_exp(<2 x half> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f16_v2i32_only_use_exp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     call __extendhfsf2
; CHECK-NEXT:     r16 = r1
; CHECK-NEXT:     memd(r29+#-16) = r17:16
; CHECK-NEXT:     allocframe(#16)
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call __extendhfsf2
; CHECK-NEXT:     r0 = r16
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = memw(r29+#4)
; CHECK-NEXT:     r17:16 = memd(r29+#8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = memw(r29+#0)
; CHECK-NEXT:     dealloc_return
; CHECK-NEXT:    }
  %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
  %result.1 = extractvalue { <2 x half>, <2 x i32> } %result, 1
  ret <2 x i32> %result.1
}

define { <3 x float>, <3 x i32> } @test_frexp_v3f32_v3i32(<3 x float> %a) nounwind {
; CHECK-LABEL: test_frexp_v3f32_v3i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r17:16 = combine(r4,r0)
; CHECK-NEXT:     r0 = r2
; CHECK-NEXT:     memd(r29+#-16) = r17:16
; CHECK-NEXT:     allocframe(#32)
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:     r18 = r3
; CHECK-NEXT:     memd(r29+#16) = r19:18
; CHECK-NEXT:     memd(r29+#8) = r21:20
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r0 = r18
; CHECK-NEXT:     r1 = add(r29,#0)
; CHECK-NEXT:     r20 = r0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r16,#24)
; CHECK-NEXT:     r21 = r0
; CHECK-NEXT:     r0 = r17
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r2 = memw(r29+#4)
; CHECK-NEXT:     r3 = memw(r29+#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     memd(r16+#0) = r21:20
; CHECK-NEXT:     memd(r16+#16) = r3:2
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     memw(r16+#8) = r0
; CHECK-NEXT:     r17:16 = memd(r29+#24)
; CHECK-EMPTY:
; CHECK-NEXT:    } :mem_noshuf // 8-byte Folded Reload
; CHECK-NEXT:    {
; CHECK-NEXT:     r19:18 = memd(r29+#16)
; CHECK-NEXT:     r21:20 = memd(r29+#8)
; CHECK-NEXT:    } // 8-byte Folded Reload
; CHECK-NEXT:    {
; CHECK-NEXT:     r31:30 = dealloc_return(r30):raw
; CHECK-NEXT:    }
  %result = call { <3 x float>, <3 x i32> } @llvm.frexp.v3f32.v3i32(<3 x float> %a)
  ret { <3 x float>, <3 x i32> } %result
}

define { float, i32 } @test_frexp_f32_i32(float %a) nounwind {
; CHECK-LABEL: test_frexp_f32_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     allocframe(r29,#8):raw
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = memw(r29+#4)
; CHECK-NEXT:     dealloc_return
; CHECK-NEXT:    }
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  ret { float, i32 } %result
}

define { float, i32 } @test_frexp_f32_i32_tailcall(float %a) nounwind {
; CHECK-LABEL: test_frexp_f32_i32_tailcall:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     allocframe(r29,#8):raw
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = memw(r29+#4)
; CHECK-NEXT:     dealloc_return
; CHECK-NEXT:    }
  %result = tail call { float, i32 } @llvm.frexp.f32.i32(float %a)
  ret { float, i32 } %result
}

define float @test_frexp_f32_i32_only_use_fract(float %a) nounwind {
; CHECK-LABEL: test_frexp_f32_i32_only_use_fract:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     allocframe(r29,#8):raw
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r31:30 = dealloc_return(r30):raw
; CHECK-NEXT:    }
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  %result.0 = extractvalue { float, i32 } %result, 0
  ret float %result.0
}

define i32 @test_frexp_f32_i32_only_use_exp(float %a) nounwind {
; CHECK-LABEL: test_frexp_f32_i32_only_use_exp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     allocframe(r29,#8):raw
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = memw(r29+#4)
; CHECK-NEXT:     dealloc_return
; CHECK-NEXT:    }
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  %result.0 = extractvalue { float, i32 } %result, 1
  ret i32 %result.0
}

define { <2 x float>, <2 x i32> } @test_frexp_v2f32_v2i32(<2 x float> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f32_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r17:16 = combine(r3,r0)
; CHECK-NEXT:     r0 = r2
; CHECK-NEXT:     memd(r29+#-16) = r17:16
; CHECK-NEXT:     allocframe(#24)
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:     memd(r29+#8) = r19:18
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r0 = r17
; CHECK-NEXT:     r1 = add(r29,#0)
; CHECK-NEXT:     r18 = r0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = combine(r0,r18)
; CHECK-NEXT:     r2 = memw(r29+#4)
; CHECK-NEXT:     r3 = memw(r29+#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     memd(r16+#0) = r1:0
; CHECK-NEXT:     memd(r16+#8) = r3:2
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r17:16 = memd(r29+#16)
; CHECK-NEXT:     r19:18 = memd(r29+#8)
; CHECK-NEXT:    } // 8-byte Folded Reload
; CHECK-NEXT:    {
; CHECK-NEXT:     r31:30 = dealloc_return(r30):raw
; CHECK-NEXT:    }
  %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
  ret { <2 x float>, <2 x i32> } %result
}

define <2 x float> @test_frexp_v2f32_v2i32_only_use_fract(<2 x float> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f32_v2i32_only_use_fract:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r16 = r1
; CHECK-NEXT:     memd(r29+#-16) = r17:16
; CHECK-NEXT:     allocframe(#16)
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r0 = r16
; CHECK-NEXT:     r1 = add(r29,#0)
; CHECK-NEXT:     r17 = r0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = combine(r0,r17)
; CHECK-NEXT:     r17:16 = memd(r29+#8)
; CHECK-NEXT:     dealloc_return
; CHECK-NEXT:    } // 8-byte Folded Reload
  %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
  %result.0 = extractvalue { <2 x float>, <2 x i32> } %result, 0
  ret <2 x float> %result.0
}

define <2 x i32> @test_frexp_v2f32_v2i32_only_use_exp(<2 x float> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f32_v2i32_only_use_exp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r16 = r1
; CHECK-NEXT:     memd(r29+#-16) = r17:16
; CHECK-NEXT:     allocframe(#16)
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#0)
; CHECK-NEXT:     r0 = r16
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = memw(r29+#4)
; CHECK-NEXT:     r17:16 = memd(r29+#8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = memw(r29+#0)
; CHECK-NEXT:     dealloc_return
; CHECK-NEXT:    }
  %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
  %result.1 = extractvalue { <2 x float>, <2 x i32> } %result, 1
  ret <2 x i32> %result.1
}

define { <4 x float>, <4 x i32> } @test_frexp_v4f32_v4i32(<4 x float> %a) nounwind {
; CHECK-LABEL: test_frexp_v4f32_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r17:16 = combine(r5,r0)
; CHECK-NEXT:     r0 = r2
; CHECK-NEXT:     memd(r29+#-16) = r17:16
; CHECK-NEXT:     allocframe(#48)
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = add(r29,#12)
; CHECK-NEXT:     r19:18 = combine(r3,r4)
; CHECK-NEXT:     memd(r29+#32) = r19:18
; CHECK-NEXT:     memd(r29+#24) = r21:20
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     memd(r29+#16) = r23:22
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r0 = r19
; CHECK-NEXT:     r1 = add(r29,#8)
; CHECK-NEXT:     r20 = r0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = r18
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:     r19 = r0
; CHECK-NEXT:     r22 = memw(r29+#12)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r23 = memw(r29+#8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r0 = r17
; CHECK-NEXT:     r1 = add(r29,#0)
; CHECK-NEXT:     r18 = r0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = combine(r0,r18)
; CHECK-NEXT:     r5:4 = combine(r19,r20)
; CHECK-NEXT:     r2 = memw(r29+#4)
; CHECK-NEXT:     r3 = memw(r29+#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     memd(r16+#8) = r1:0
; CHECK-NEXT:     memd(r16+#0) = r5:4
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     memd(r16+#24) = r3:2
; CHECK-NEXT:     memd(r16+#16) = r23:22
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r17:16 = memd(r29+#40)
; CHECK-NEXT:     r19:18 = memd(r29+#32)
; CHECK-NEXT:    } // 8-byte Folded Reload
; CHECK-NEXT:    {
; CHECK-NEXT:     r21:20 = memd(r29+#24)
; CHECK-NEXT:     r23:22 = memd(r29+#16)
; CHECK-NEXT:    } // 8-byte Folded Reload
; CHECK-NEXT:    {
; CHECK-NEXT:     r31:30 = dealloc_return(r30):raw
; CHECK-NEXT:    }
  %result = call { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float> %a)
  ret { <4 x float>, <4 x i32> } %result
}

define <4 x float> @test_frexp_v4f32_v4i32_only_use_fract(<4 x float> %a) nounwind {
; CHECK-LABEL: test_frexp_v4f32_v4i32_only_use_fract:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r17:16 = combine(r5,r0)
; CHECK-NEXT:     r0 = r2
; CHECK-NEXT:     memd(r29+#-16) = r17:16
; CHECK-NEXT:     allocframe(#40)
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = add(r29,#12)
; CHECK-NEXT:     r19:18 = combine(r3,r4)
; CHECK-NEXT:     memd(r29+#24) = r19:18
; CHECK-NEXT:     memd(r29+#16) = r21:20
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r0 = r19
; CHECK-NEXT:     r1 = add(r29,#8)
; CHECK-NEXT:     r20 = r0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r0 = r18
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:     r19 = r0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r0 = r17
; CHECK-NEXT:     r1 = add(r29,#0)
; CHECK-NEXT:     r18 = r0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = combine(r0,r18)
; CHECK-NEXT:     r3:2 = combine(r19,r20)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     memd(r16+#8) = r1:0
; CHECK-NEXT:     memd(r16+#0) = r3:2
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r17:16 = memd(r29+#32)
; CHECK-NEXT:     r19:18 = memd(r29+#24)
; CHECK-NEXT:    } // 8-byte Folded Reload
; CHECK-NEXT:    {
; CHECK-NEXT:     r21:20 = memd(r29+#16)
; CHECK-NEXT:     dealloc_return
; CHECK-NEXT:    } // 8-byte Folded Reload
  %result = call { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float> %a)
  %result.0 = extractvalue { <4 x float>, <4 x i32> } %result, 0
  ret <4 x float> %result.0
}

define <4 x i32> @test_frexp_v4f32_v4i32_only_use_exp(<4 x float> %a) nounwind {
; CHECK-LABEL: test_frexp_v4f32_v4i32_only_use_exp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r17:16 = combine(r5,r0)
; CHECK-NEXT:     r0 = r2
; CHECK-NEXT:     memd(r29+#-16) = r17:16
; CHECK-NEXT:     allocframe(#32)
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r19:18 = combine(r3,r4)
; CHECK-NEXT:     r1 = add(r29,#12)
; CHECK-NEXT:     memd(r29+#16) = r19:18
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#8)
; CHECK-NEXT:     r0 = r19
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#4)
; CHECK-NEXT:     r0 = r18
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexpf
; CHECK-NEXT:     r1 = add(r29,#0)
; CHECK-NEXT:     r0 = r17
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = memw(r29+#12)
; CHECK-NEXT:     r2 = memw(r29+#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = memw(r29+#8)
; CHECK-NEXT:     r3 = memw(r29+#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     memd(r16+#8) = r3:2
; CHECK-NEXT:     memd(r16+#0) = r1:0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r17:16 = memd(r29+#24)
; CHECK-NEXT:     r19:18 = memd(r29+#16)
; CHECK-NEXT:    } // 8-byte Folded Reload
; CHECK-NEXT:    {
; CHECK-NEXT:     r31:30 = dealloc_return(r30):raw
; CHECK-NEXT:    }
  %result = call { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float> %a)
  %result.1 = extractvalue { <4 x float>, <4 x i32> } %result, 1
  ret <4 x i32> %result.1
}

define { double, i32 } @test_frexp_f64_i32(double %a) nounwind {
; CHECK-LABEL: test_frexp_f64_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r16 = r0
; CHECK-NEXT:     r1:0 = combine(r3,r2)
; CHECK-NEXT:     memd(r29+#-16) = r17:16
; CHECK-NEXT:     allocframe(#8)
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexp
; CHECK-NEXT:     r2 = add(r16,#8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     memd(r16+#0) = r1:0
; CHECK-NEXT:     r17:16 = memd(r29+#0)
; CHECK-EMPTY:
; CHECK-NEXT:    } :mem_noshuf // 8-byte Folded Reload
; CHECK-NEXT:    {
; CHECK-NEXT:     r31:30 = dealloc_return(r30):raw
; CHECK-NEXT:    }
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  ret { double, i32 } %result
}

define double @test_frexp_f64_i32_only_use_fract(double %a) nounwind {
; CHECK-LABEL: test_frexp_f64_i32_only_use_fract:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     allocframe(r29,#8):raw
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexp
; CHECK-NEXT:     r2 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r31:30 = dealloc_return(r30):raw
; CHECK-NEXT:    }
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  %result.0 = extractvalue { double, i32 } %result, 0
  ret double %result.0
}

define i32 @test_frexp_f64_i32_only_use_exp(double %a) nounwind {
; CHECK-LABEL: test_frexp_f64_i32_only_use_exp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     allocframe(r29,#8):raw
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexp
; CHECK-NEXT:     r2 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = memw(r29+#4)
; CHECK-NEXT:     dealloc_return
; CHECK-NEXT:    }
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  %result.0 = extractvalue { double, i32 } %result, 1
  ret i32 %result.0
}

define { <2 x double>, <2 x i32> } @test_frexp_v2f64_v2i32(<2 x double> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f64_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r16 = r0
; CHECK-NEXT:     r1:0 = combine(r3,r2)
; CHECK-NEXT:     memd(r29+#-16) = r17:16
; CHECK-NEXT:     allocframe(#32)
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     r2 = add(r29,#4)
; CHECK-NEXT:     r19:18 = combine(r5,r4)
; CHECK-NEXT:     memd(r29+#16) = r19:18
; CHECK-NEXT:     memd(r29+#8) = r21:20
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexp
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexp
; CHECK-NEXT:     r21:20 = combine(r1,r0)
; CHECK-NEXT:     r1:0 = combine(r19,r18)
; CHECK-NEXT:     r2 = add(r29,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r2 = memw(r29+#4)
; CHECK-NEXT:     r3 = memw(r29+#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     memd(r16+#8) = r1:0
; CHECK-NEXT:     memd(r16+#0) = r21:20
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     memd(r16+#16) = r3:2
; CHECK-NEXT:     r17:16 = memd(r29+#24)
; CHECK-EMPTY:
; CHECK-NEXT:    } :mem_noshuf // 8-byte Folded Reload
; CHECK-NEXT:    {
; CHECK-NEXT:     r19:18 = memd(r29+#16)
; CHECK-NEXT:     r21:20 = memd(r29+#8)
; CHECK-NEXT:    } // 8-byte Folded Reload
; CHECK-NEXT:    {
; CHECK-NEXT:     r31:30 = dealloc_return(r30):raw
; CHECK-NEXT:    }
  %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
  ret { <2 x double>, <2 x i32> } %result
}

define <2 x double> @test_frexp_v2f64_v2i32_only_use_fract(<2 x double> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f64_v2i32_only_use_fract:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r16 = r0
; CHECK-NEXT:     r1:0 = combine(r3,r2)
; CHECK-NEXT:     memd(r29+#-16) = r17:16
; CHECK-NEXT:     allocframe(#32)
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     r2 = add(r29,#4)
; CHECK-NEXT:     r19:18 = combine(r5,r4)
; CHECK-NEXT:     memd(r29+#16) = r19:18
; CHECK-NEXT:     memd(r29+#8) = r21:20
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexp
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexp
; CHECK-NEXT:     r21:20 = combine(r1,r0)
; CHECK-NEXT:     r1:0 = combine(r19,r18)
; CHECK-NEXT:     r2 = add(r29,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     memd(r16+#8) = r1:0
; CHECK-NEXT:     memd(r16+#0) = r21:20
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r17:16 = memd(r29+#24)
; CHECK-NEXT:     r19:18 = memd(r29+#16)
; CHECK-NEXT:    } // 8-byte Folded Reload
; CHECK-NEXT:    {
; CHECK-NEXT:     r21:20 = memd(r29+#8)
; CHECK-NEXT:     dealloc_return
; CHECK-NEXT:    } // 8-byte Folded Reload
  %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
  %result.0 = extractvalue { <2 x double>, <2 x i32> } %result, 0
  ret <2 x double> %result.0
}

define <2 x i32> @test_frexp_v2f64_v2i32_only_use_exp(<2 x double> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f64_v2i32_only_use_exp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r17:16 = combine(r3,r2)
; CHECK-NEXT:     memd(r29+#-16) = r17:16
; CHECK-NEXT:     allocframe(#16)
; CHECK-NEXT:    } // 8-byte Folded Spill
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexp
; CHECK-NEXT:     r2 = add(r29,#4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     call frexp
; CHECK-NEXT:     r1:0 = combine(r17,r16)
; CHECK-NEXT:     r2 = add(r29,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = memw(r29+#4)
; CHECK-NEXT:     r17:16 = memd(r29+#8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = memw(r29+#0)
; CHECK-NEXT:     dealloc_return
; CHECK-NEXT:    }
  %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
  %result.1 = extractvalue { <2 x double>, <2 x i32> } %result, 1
  ret <2 x i32> %result.1
}

declare { float, i32 } @llvm.frexp.f32.i32(float) #0
declare { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float>) #0
declare { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float>) #0

declare { half, i32 } @llvm.frexp.f16.i32(half) #0
declare { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half>) #0

declare { double, i32 } @llvm.frexp.f64.i32(double) #0
declare { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double>) #0

declare { half, i16 } @llvm.frexp.f16.i16(half) #0
declare { <2 x half>, <2 x i16> } @llvm.frexp.v2f16.v2i16(<2 x half>) #0

attributes #0 = { nocallback nofree nosync nounwind speculatable willreturn memory(none) }
