/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.office;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.odftoolkit.odfdom.dom.element.number.NumberBooleanStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextStyleElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberCurrencyStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberDateStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberPercentageStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberTimeStyle;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextListStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;

class OdfStylesBase {
    private HashMap<OdfStyleFamily, HashMap<String, OdfStyle>> mStyles;
    private HashMap<String, OdfTextListStyle> mListStyles;
    private HashMap<String, OdfNumberStyle> mNumberStyles;
    private HashMap<String, OdfNumberDateStyle> mDateStyles;
    private HashMap<String, OdfNumberPercentageStyle> mPercentageStyles;
    private HashMap<String, OdfNumberCurrencyStyle> mCurrencyStyles;
    private HashMap<String, OdfNumberTimeStyle> mTimeStyles;
    private HashMap<String, NumberBooleanStyleElement> mBooleanStyles;
    private HashMap<String, NumberTextStyleElement> mTextStyles;

    OdfStylesBase() {
    }

    OdfStyle getStyle(String name, OdfStyleFamily familyType) {
        HashMap<String, OdfStyle> familyMap;
        if (this.mStyles != null && (familyMap = this.mStyles.get(familyType)) != null) {
            return familyMap.get(name);
        }
        return null;
    }

    Iterable<OdfStyle> getAllOdfStyles() {
        ArrayList<OdfStyle> allStyles = new ArrayList<OdfStyle>();
        if (this.mStyles != null) {
            for (OdfStyleFamily family : this.mStyles.keySet()) {
                HashMap<String, OdfStyle> familySet = this.mStyles.get(family);
                Collection<OdfStyle> familyStyles = familySet.values();
                allStyles.addAll(familyStyles);
            }
        }
        return allStyles;
    }

    Iterable<OdfStyle> getStylesForFamily(OdfStyleFamily familyType) {
        HashMap<String, OdfStyle> familyMap;
        if (this.mStyles != null && (familyMap = this.mStyles.get(familyType)) != null) {
            return familyMap.values();
        }
        return new ArrayList<OdfStyle>();
    }

    OdfTextListStyle getListStyle(String name) {
        if (this.mListStyles != null) {
            return this.mListStyles.get(name);
        }
        return null;
    }

    Iterable<OdfTextListStyle> getListStyles() {
        if (this.mListStyles != null) {
            return this.mListStyles.values();
        }
        return new ArrayList<OdfTextListStyle>();
    }

    OdfNumberStyle getNumberStyle(String name) {
        if (this.mNumberStyles != null) {
            return this.mNumberStyles.get(name);
        }
        return null;
    }

    Iterable<OdfNumberStyle> getNumberStyles() {
        if (this.mNumberStyles != null) {
            return this.mNumberStyles.values();
        }
        return new ArrayList<OdfNumberStyle>();
    }

    OdfNumberDateStyle getDateStyle(String name) {
        if (this.mDateStyles != null) {
            return this.mDateStyles.get(name);
        }
        return null;
    }

    Iterable<OdfNumberDateStyle> getDateStyles() {
        if (this.mDateStyles != null) {
            return this.mDateStyles.values();
        }
        return new ArrayList<OdfNumberDateStyle>();
    }

    OdfNumberPercentageStyle getPercentageStyle(String name) {
        if (this.mPercentageStyles != null) {
            return this.mPercentageStyles.get(name);
        }
        return null;
    }

    Iterable<OdfNumberPercentageStyle> getPercentageStyles() {
        if (this.mPercentageStyles != null) {
            return this.mPercentageStyles.values();
        }
        return new ArrayList<OdfNumberPercentageStyle>();
    }

    OdfNumberCurrencyStyle getCurrencyStyle(String name) {
        if (this.mCurrencyStyles != null) {
            return this.mCurrencyStyles.get(name);
        }
        return null;
    }

    Iterable<OdfNumberCurrencyStyle> getCurrencyStyles() {
        if (this.mCurrencyStyles != null) {
            return this.mCurrencyStyles.values();
        }
        return new ArrayList<OdfNumberCurrencyStyle>();
    }

    OdfNumberTimeStyle getTimeStyle(String name) {
        if (this.mTimeStyles != null) {
            return this.mTimeStyles.get(name);
        }
        return null;
    }

    Iterable<OdfNumberTimeStyle> getTimeStyles() {
        if (this.mTimeStyles != null) {
            return this.mTimeStyles.values();
        }
        return new ArrayList<OdfNumberTimeStyle>();
    }

    NumberBooleanStyleElement getBooleanStyle(String name) {
        if (this.mBooleanStyles != null) {
            return this.mBooleanStyles.get(name);
        }
        return null;
    }

    Iterable<NumberBooleanStyleElement> getBooleanStyles() {
        if (this.mBooleanStyles != null) {
            return this.mBooleanStyles.values();
        }
        return new ArrayList<NumberBooleanStyleElement>();
    }

    NumberTextStyleElement getTextStyle(String name) {
        if (this.mTextStyles != null) {
            return this.mTextStyles.get(name);
        }
        return null;
    }

    Iterable<NumberTextStyleElement> getTextStyles() {
        if (this.mTextStyles != null) {
            return this.mTextStyles.values();
        }
        return new ArrayList<NumberTextStyleElement>();
    }

    void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof OdfStyle) {
            HashMap<String, OdfStyle> familyMap;
            OdfStyle style = (OdfStyle)node;
            if (this.mStyles == null) {
                this.mStyles = new HashMap();
            }
            if ((familyMap = this.mStyles.get(style.getFamily())) == null) {
                familyMap = new HashMap();
                this.mStyles.put(style.getFamily(), familyMap);
            }
            familyMap.put(style.getStyleNameAttribute(), style);
        } else if (node instanceof OdfTextListStyle) {
            OdfTextListStyle listStyle = (OdfTextListStyle)node;
            if (this.mListStyles == null) {
                this.mListStyles = new HashMap();
            }
            this.mListStyles.put(listStyle.getStyleNameAttribute(), listStyle);
        } else if (node instanceof OdfNumberStyle) {
            OdfNumberStyle numberStyle = (OdfNumberStyle)node;
            if (this.mNumberStyles == null) {
                this.mNumberStyles = new HashMap();
            }
            this.mNumberStyles.put(numberStyle.getStyleNameAttribute(), numberStyle);
        } else if (node instanceof OdfNumberDateStyle) {
            OdfNumberDateStyle dateStyle = (OdfNumberDateStyle)node;
            if (this.mDateStyles == null) {
                this.mDateStyles = new HashMap();
            }
            this.mDateStyles.put(dateStyle.getStyleNameAttribute(), dateStyle);
        } else if (node instanceof OdfNumberPercentageStyle) {
            OdfNumberPercentageStyle percentageStyle = (OdfNumberPercentageStyle)node;
            if (this.mPercentageStyles == null) {
                this.mPercentageStyles = new HashMap();
            }
            this.mPercentageStyles.put(percentageStyle.getStyleNameAttribute(), percentageStyle);
        } else if (node instanceof OdfNumberCurrencyStyle) {
            OdfNumberCurrencyStyle currencyStyle = (OdfNumberCurrencyStyle)node;
            if (this.mCurrencyStyles == null) {
                this.mCurrencyStyles = new HashMap();
            }
            this.mCurrencyStyles.put(currencyStyle.getStyleNameAttribute(), currencyStyle);
        } else if (node instanceof OdfNumberTimeStyle) {
            OdfNumberTimeStyle timeStyle = (OdfNumberTimeStyle)node;
            if (this.mTimeStyles == null) {
                this.mTimeStyles = new HashMap();
            }
            this.mTimeStyles.put(timeStyle.getStyleNameAttribute(), timeStyle);
        } else if (node instanceof NumberBooleanStyleElement) {
            NumberBooleanStyleElement booleanStyle = (NumberBooleanStyleElement)node;
            if (this.mBooleanStyles == null) {
                this.mBooleanStyles = new HashMap();
            }
            this.mBooleanStyles.put(booleanStyle.getStyleNameAttribute(), booleanStyle);
        } else if (node instanceof NumberTextStyleElement) {
            NumberTextStyleElement textStyle = (NumberTextStyleElement)node;
            if (this.mTextStyles == null) {
                this.mTextStyles = new HashMap();
            }
            this.mTextStyles.put(textStyle.getStyleNameAttribute(), textStyle);
        }
    }

    void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof OdfStyle) {
            OdfStyle style;
            HashMap<String, OdfStyle> familyMap;
            if (this.mStyles != null && (familyMap = this.mStyles.get((style = (OdfStyle)node).getFamily())) != null) {
                familyMap.remove(style.getStyleNameAttribute());
                if (familyMap.isEmpty()) {
                    this.mStyles.remove(style.getFamily());
                }
            }
        } else if (node instanceof OdfTextListStyle) {
            if (this.mListStyles != null) {
                OdfTextListStyle listStyle = (OdfTextListStyle)node;
                this.mListStyles.remove(listStyle.getStyleNameAttribute());
            }
        } else if (node instanceof OdfNumberStyle) {
            if (this.mNumberStyles != null) {
                OdfNumberStyle numberStyle = (OdfNumberStyle)node;
                this.mNumberStyles.remove(numberStyle.getStyleNameAttribute());
            }
        } else if (node instanceof OdfNumberDateStyle) {
            if (this.mDateStyles != null) {
                OdfNumberDateStyle dateStyle = (OdfNumberDateStyle)node;
                this.mDateStyles.remove(dateStyle.getStyleNameAttribute());
            }
        } else if (node instanceof OdfNumberPercentageStyle) {
            if (this.mPercentageStyles != null) {
                OdfNumberPercentageStyle percentageStyle = (OdfNumberPercentageStyle)node;
                this.mPercentageStyles.remove(percentageStyle.getStyleNameAttribute());
            }
        } else if (node instanceof OdfNumberCurrencyStyle) {
            if (this.mCurrencyStyles != null) {
                OdfNumberCurrencyStyle currencyStyle = (OdfNumberCurrencyStyle)node;
                this.mCurrencyStyles.remove(currencyStyle.getStyleNameAttribute());
            }
        } else if (node instanceof OdfNumberTimeStyle) {
            if (this.mTimeStyles != null) {
                OdfNumberTimeStyle timeStyle = (OdfNumberTimeStyle)node;
                this.mTimeStyles.remove(timeStyle.getStyleNameAttribute());
            }
        } else if (node instanceof NumberBooleanStyleElement) {
            if (this.mBooleanStyles != null) {
                NumberBooleanStyleElement booleanStyle = (NumberBooleanStyleElement)node;
                this.mBooleanStyles.remove(booleanStyle.getStyleNameAttribute());
            }
        } else if (node instanceof NumberTextStyleElement && this.mTextStyles != null) {
            NumberTextStyleElement textStyle = (NumberTextStyleElement)node;
            this.mTextStyles.remove(textStyle.getStyleNameAttribute());
        }
    }
}

