/* This file is part of the wvWare 2 project
   SPDX-FileCopyrightText: 2002-2003 Werner Trobin <trobin@kde.org>
   SPDX-FileCopyrightText: 2011 Matus Uzak <matus.uzak@ixonos.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02111-1307, USA.
*/

#ifndef FOOTNOTES97_H
#define FOOTNOTES97_H

#include "functordata.h"
#include "global.h"

#include "wv2_export.h"
#include <vector>

namespace wvWare
{
namespace Word97
{
struct FIB;
struct FRD;
}
template<class T>
class PLCF;
template<class T>
class PLCFIterator;
class OLEStreamReader;
struct FootnoteData;

/**
 * @internal
 */
class Footnotes97
{
public:
    Footnotes97(OLEStreamReader *tableStream, const Word97::FIB &fib);
    ~Footnotes97();

    /**
     * Get the FootnoteData for the footnote/endnote at @param globalCP.
     * The @param ok flag is true if a footnote/endnote has been found.
     * If @param ok is false no footnote/endnote has been found and the
     * returned FootnoteData structure is invalid.
     */
    FootnoteData footnote(U32 globalCP, bool &ok);

    /**
     * Returns the global CP of the next footnote reference,
     * 0xffffffff if none exists.
     */
    U32 nextFootnote() const;
    /**
     * Returns the global CP of the next endnote reference,
     * 0xffffffff if none exists.
     */
    U32 nextEndnote() const;

    /**
     * Check for unprocessed footnotes/endnotes located before @param
     * globalCP.  This might be the result of a skipped chunk or
     * overlapping.  Any unprocessed footnotes/endnotes are skipped.
     */
    void check(U32 globalCP);

private:
    Footnotes97(const Footnotes97 &rhs) = delete;
    Footnotes97 &operator=(const Footnotes97 &rhs) = delete;

    // Ugly, but helps to avoid code duplication
    void init(U32 fcRef,
              U32 lcbRef,
              U32 fcTxt,
              U32 lcbTxt,
              OLEStreamReader *tableStream,
              PLCF<Word97::FRD> **ref,
              PLCFIterator<Word97::FRD> **refIt,
              std::vector<U32> &txt,
              std::vector<U32>::const_iterator &txtIt);

    PLCF<Word97::FRD> *m_footnoteRef;
    PLCFIterator<Word97::FRD> *m_footnoteRefIt;
    std::vector<U32> m_footnoteTxt;
    std::vector<U32>::const_iterator m_footnoteTxtIt;

    PLCF<Word97::FRD> *m_endnoteRef;
    PLCFIterator<Word97::FRD> *m_endnoteRefIt;
    std::vector<U32> m_endnoteTxt;
    std::vector<U32>::const_iterator m_endnoteTxtIt;
};

} // namespace wvWare

#endif // FOOTNOTES97_H
