<?php

use Symfony\Bundle\FrameworkBundle\Tests\DependencyInjection\FrameworkExtensionTestCase;

$container->loadFromExtension('framework', [
    'annotations' => false,
    'http_method_override' => false,
    'handle_all_throwables' => true,
    'php_errors' => ['log' => true],
    'workflows' => [
        'my_workflow' => [
            'type' => 'state_machine',
            'supports' => [
                FrameworkExtensionTestCase::class,
            ],
            'places' => [
                'first',
                'middle',
                'last',
            ],
            'transitions' => [
                'go' => [
                    'from' => [
                        'first',
                    ],
                    'to' => [
                        'middle',
                        'last',
                    ],
                ],
            ],
        ],
    ],
]);
